
#ifndef CHARSTACKTYPE_H
#define CHARSTACKTYPE_H

struct stackNode;

typedef stackNode * nodePtr;

struct stackNode
{
  char value;
  nodePtr next;
};


class charStackType		
{
  public:		
    charStackType();					//constructor
    void push(char value);				//pushes character onto stack
    char pop();							//pops character from stack-returns as char 
    									//  - return null character if stack is empty
    void pop(char &value);				//pops character from stack into parameter value
    									//  - returns null character if stack is empty
    char topValue() const;				//returns top character on stack - does not pop
    inline bool isEmpty() const;				//returns true if stack is empty
    void printStack() const;			//prints all characters in stack
    ~charStackType();					//destructor

    
  private:
    nodePtr stackTop;					//points to top value in stack
};


#endif