#include <iostream.h>
#include "charStackType.h"


/*********************Public Member Functions*************************/


charStackType::charStackType()
{
  stackTop = NULL;
}


/*********************************************************************/


void charStackType::push(char value)
{
  nodePtr temp = new stackNode;
  
  temp->value = value;
  temp->next = stackTop;
  stackTop = temp;
}
//add stackoverflow error?


/*********************************************************************/


char charStackType::pop()
{
  if ( !isEmpty() )						//If there is a value to pop
  {
    char tempvalue = stackTop->value;	//put value in temporary variable
    nodePtr temp = stackTop;			//create temporary ptr to stackTop
  
    stackTop = stackTop->next;			//move stackTop to next stack element
    delete temp;						//delete popped value
    return(tempvalue);					//return value
  }
  else
    return('\0');				//If stack is empty, return null character
}


/*********************************************************************/


void charStackType::pop(char &value)
{
  if ( !isEmpty() )
  {
    value = stackTop->value;
    nodePtr temp = stackTop;
  
    stackTop = stackTop->next;
    delete temp;
  }
  else
    value = '\0';
}


/*********************************************************************/


char charStackType::topValue() const
{
  return ( ( isEmpty() ) ? ('\0') : (stackTop->value) ) ;
}


/*********************************************************************/


inline bool charStackType::isEmpty() const
{
  return( stackTop == NULL);
}


/*********************************************************************/


void charStackType::printStack() const
{
  nodePtr traverse = stackTop;
  while ( traverse != NULL )
  {
    cout << endl << traverse->value;
    traverse = traverse->next;
  }
}


/*********************************************************************/


charStackType::~charStackType()
{
  nodePtr temp;
  
  while ( stackTop != NULL )
  {
    temp = stackTop;
    stackTop = stackTop->next;
    delete temp;
  }
}