#include<iostream.h>



struct elementType
{
    int item;
    elementType* next;
};

typedef elementType* elementPtr;

class stackType
{
	public:
		stackType();		// constructor
		bool isempty();		// checks if array is empty
		void push(int);		// pushes number onto the stack
		int pop();			// pops number off of stack
		
	private:												
		elementPtr head;										

};

//////// BEGINNING OF CONSTRUCTOR //////////////////////////////////
// INITIALIZES THE VARIABLES TO ZERO

stackType::stackType()
{
	head = NULL;
}

//////// BEGINNING OF ISEMPTY FUNCTION //////////////////////////////
// CHECKS TO SEE IF THE ARRAY IS EMPTY
// USES A SERIES OF IF STATEMENTS TO SEE IF ARRAY IS EMPTY
// IF EMPTY RETURNS TRUE AND IF NOT EMPTY RETURNS FALSE

bool stackType::isempty()
{
	if(head == NULL)
	{	
		cout << "Error! Array is empty" << endl;
		cout << "Please input calculations" << endl;
		return true;
	}
	else
		return false;
}

//////// BEGINNING OF PUSH FUNCTION /////////////////////////////////
// PUSHES THE DIGITS ONTO THE STACK
// AN IF STATEMENT IS USED TO MAKE SURE THE ARRAY IS NOT FULL
// THE ANSWER IS PLACED INTO THE BEGINNING OF THE STACK
// GOES TO EVALUATEPOSTFIXEPRESSOIN FUNCTION

void stackType::push(int item)
{	
	
	elementPtr tempPtr = head;
	head = new elementType;
	head->item = item;
	head->next = tempPtr;
	
	
}

//////// BEGINNING OF POP FUNCTION //////////////////////////////////
// POPS THE FIRST TWO DIGITS OFF THE STACK
// GRABS THE FIRST 2 DIGITS IN THE STACK 
// GOES TO THE CALCULATE FUNCTION

int stackType::pop()
{
	int temp;

	elementPtr tempPtr = head;
	head = tempPtr->next;
	temp = tempPtr->item;
	delete tempPtr;
	
	return (temp);
}



	
//////// BEGINNING OF DRIVER PROGRAM /////////////////////////////////

int main ()
{
	stackType solve;
	char user_input[80];

	int tempVarOne;
	int tempVarTwo;

	cout << "Enter a postfix expression to be solved" << endl;
	cin.getline(user_input, 80, '\n');

	for (int ii = 0; user_input[ii] != '\0'; ii ++) {
		if (user_input[ii] == ' ')
			continue;

		if (user_input[ii] == '+') {
			tempVarOne = solve.pop();
			tempVarTwo = solve.pop();
			solve.push(tempVarOne + tempVarTwo);
		}

		if (user_input[ii] == '-') {
			tempVarOne = solve.pop();
			tempVarTwo = solve.pop();
			solve.push(tempVarTwo - tempVarOne);
		}
		if (user_input[ii] == '*') {
			tempVarOne = solve.pop();
			tempVarTwo = solve.pop();
			solve.push(tempVarOne * tempVarTwo);
		}
		if (user_input[ii] == '/') {
			tempVarOne = solve.pop();
			tempVarTwo = solve.pop();
			solve.push(tempVarTwo / tempVarOne);
		}
		if (user_input[ii] == '%') {
			tempVarOne = solve.pop();
			tempVarTwo = solve.pop();
			solve.push(tempVarTwo % tempVarOne);
		}
		if (((user_input[ii] - '0') >= 0) && ((user_input[ii] - '0') <= 9))
			solve.push(user_input[ii] - '0');


	}
	cout << endl << solve.pop() << endl;
	return (0);
}
